using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;

/*
   PictureHEXView is a simple picture and color-in-hexa viewer
   which tracks pixel values under the cursor.
   Demonstrates use of OpenFileDialog for loading
   image files and Type-overcasting for get color codes for a pixel.
   Made by Endre I. Simay, Hungary
*/

namespace PictureHEXView {
    /// <summary>
    /// Summary description for WinForm.
    /// </summary>
public class WinForm : System.Windows.Forms.Form {
        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.Container components = null;
        private System.Windows.Forms.Panel panel1;
        private System.Windows.Forms.PictureBox pictureBox1;
        private System.Windows.Forms.Button button1;
        private System.Windows.Forms.OpenFileDialog openFileDialog1;

        System.Drawing.Color color = new System.Drawing.Color();

        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.Label label2;
        private System.Windows.Forms.Label label3;
        public WinForm() {
            //
            // Required for Windows Form Designer support
            //
            InitializeComponent();

            //
            // TODO: Add any constructor code after InitializeComponent call
            //
        }

		/// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose (bool disposing) {
            if (disposing) {
                if (components != null) {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
		{
			this.panel1 = new System.Windows.Forms.Panel();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.button1 = new System.Windows.Forms.Button();
			this.openFileDialog1 = new System.Windows.Forms.OpenFileDialog();
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.panel1.SuspendLayout();
			this.SuspendLayout();
			// 
			// panel1
			// 
			this.panel1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.panel1.AutoScroll = true;
			this.panel1.Controls.Add(this.pictureBox1);
			this.panel1.Location = new System.Drawing.Point(8, 8);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(360, 232);
			this.panel1.TabIndex = 0;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Location = new System.Drawing.Point(0, 0);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			this.pictureBox1.MouseMove += new System.Windows.Forms.MouseEventHandler(this.pictureBox1_MouseMove);
			// 
			// button1
			// 
			this.button1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.button1.Location = new System.Drawing.Point(8, 248);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(88, 23);
			this.button1.TabIndex = 1;
			this.button1.Text = "Load Image ...";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// openFileDialog1
			// 
			this.openFileDialog1.Filter = "All known (*.bmp;*.gif;*.ico;*.jpg;*.png)|*.bmp;*.gif;*.ico;*.jpg;" +  
				"*.png";
			// 
			// label1
			// 
			this.label1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.label1.ForeColor = System.Drawing.Color.FromArgb(((byte)(192)), ((byte)(0)), ((byte)(0)));
			this.label1.Location = new System.Drawing.Point(112, 256);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(72, 16);
			this.label1.TabIndex = 2;
			this.label1.Text = "Red  :";
			// 
			// label2
			// 
			this.label2.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.label2.ForeColor = System.Drawing.Color.FromArgb(((byte)(0)), ((byte)(192)), ((byte)(0)));
			this.label2.Location = new System.Drawing.Point(200, 256);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(72, 16);
			this.label2.TabIndex = 3;
			this.label2.Text = "Green :";
			// 
			// label3
			// 
			this.label3.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.label3.ForeColor = System.Drawing.Color.FromArgb(((byte)(0)), ((byte)(0)), ((byte)(192)));
			this.label3.Location = new System.Drawing.Point(288, 256);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(72, 16);
			this.label3.TabIndex = 4;
			this.label3.Text = "Blue :";
			// 
			// WinForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(377, 286);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.button1);
			this.Controls.Add(this.panel1);
			this.MinimumSize = new System.Drawing.Size(385, 320);
			this.Name = "WinForm";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "PictureHexView";
			this.panel1.ResumeLayout(false);
			this.ResumeLayout(false);
		}
        #endregion

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main() {
            Application.Run(new WinForm());
        }


        private bool open_and_view() {
            string fname;
            if ((fname = openFileDialog1.FileName)!= "") {
                try {
                    try {
                        if (pictureBox1.Image!= null) {
                            pictureBox1.Image.Dispose();
                        }
                        pictureBox1.Image = Image.FromFile(fname);
                    } catch (Exception) {
                        return false;
					}
                    return true;
                } catch (Exception) {
                    return false;
                }
            } else {
                return false;
            }
        }

        private void button1_Click(object sender, System.EventArgs e) {
            if (openFileDialog1.ShowDialog() == DialogResult.OK) {
                if (!open_and_view()) {
                    // a simple error-recording

                    MessageBox.Show("Problem with picture path or format." + "Sorry", "Pictureview Error",
                                    MessageBoxButtons.OK);
                }
            }
        }

        string stemp;

        private void pictureBox1_MouseMove(object sender, System.Windows.Forms.MouseEventArgs e) {

            if (pictureBox1.Image != null) {
                // The Image-type has not a GetPixel function. So we use the Bitmap's one
                color = ((System.Drawing.Bitmap)pictureBox1.Image).GetPixel(e.X,e.Y);

                // A very stone-axe method to padding the byte to hexa with 2 chars
                stemp = color.R.ToString("X");
                if (stemp.Length == 1) {
                    stemp = "0"+ stemp;
                }
                label1.Text = "Red  : 0x" + stemp;

                stemp = color.G.ToString("X");
                if (stemp.Length == 1) {
                    stemp = "0"+ stemp;
                }
                label2.Text = "Green: 0x" + stemp;

                stemp = color.B.ToString("X");
                if (stemp.Length == 1) {
                    stemp = "0"+ stemp;
                }
                label3.Text = "Blue : 0x" + stemp;
            }
        }

    }
}


